package gov.va.med.mhv.sm.admin.repository;

import java.util.Collection;
import java.util.Date;

import gov.va.med.mhv.sm.admin.model.Addressee;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;


@Repository
public interface AddresseeRepository extends JpaRepository<Addressee, Long>{
	
	/**
	 * findMessageById
	 * @param id
	 * @return Message
	 */
	@Query("select ad from Addressee ad where ad.id = :id")
	Addressee findAddresseeById(@Param("id") Long id);
	

	@Query("select adse from Addressee adse, Message sm "
			+ "where adse.message.id = sm.id "
			+ "and adse.userId = :userId "
			+ "and adse.folderId = 0 ")
	Page<Addressee> getMessages(@Param("userId")Long userId, Pageable pageRequest);
	
	
	@Query("select adse from Addressee adse "
			+ "where adse.messageId=:messageId "
			+ "and adse.userId=:userId ")
	Addressee getAddresseeForUser(@Param("userId")Long userId, @Param("messageId")Long messageId);
	
	@Query("select adse from Addressee adse "
			+ "where adse.messageId=:messageId ")
	Collection<Addressee> getAddresseesByMessage(@Param("messageId")Long messageId);
	
	@Query("select adse.folderId,count(adse.folderId),count(adse.readDate) from Addressee adse, Message m"
			+ " where adse.messageId = m.id and adse.userId=:userId and adse.createdDate > :yearFrom and adse.active=1 and m.active=1 group by adse.folderId")
	Collection<Object[]> getFolderCounts(@Param("userId")Long userId, @Param("yearFrom")Date yearFrom);
	
    
    @Query("select t.messageCategoryTypeId,count(adse.folderId),count(adse.readDate) from Addressee adse, Message m, Thread t"
			+ " where adse.messageId = m.id and m.id = t.id and adse.userId=:userId and adse.createdDate > :yearFrom "
			+ " and adse.active=1 and m.active=1 and adse.folderId=0 group by t.messageCategoryTypeId")
	Collection<Object[]> getCategoryCounts(@Param("userId")Long userId, @Param("yearFrom")Date yearFrom);
	
    
	
}